<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User;

use Erlage\Photogram\Tools\Crypto;
use Erlage\Photogram\Reflection\TraitReflectionClassName;

final class UserTransformer
{
    use TraitReflectionClassName;

    public static function password(string $password): string
    {
        return Crypto::databaseHashFromClearPassword($password);
    }

    public static function metaAccess(string $metaAccess): string
    {
        if (empty($metaAccess))
        {
            // generate random
            return Crypto::databaseHashFromClearPassword(Crypto::randomString(32));
        }

        return $metaAccess;
    }
}
